import { Component, OnInit, Inject, ViewEncapsulation } from '@angular/core';
import { Router } from '@angular/router';
import { MenusService } from './core/menus/menus.service';
import { MainContentService } from './core/maincontent/maincontent.service';
import { Menu } from './core/menus/menu';
import { MainContent } from './core/maincontent/maincontent';
import { ErrorService } from './core/error-messages/error.service';
import { ErrorMessage } from './core/error-messages/error-message';
import {
  FormControl,
  FormGroup,
  Validators
} from '@angular/forms';

import { LocalConfig } from './core/config/local-config'
import { Config, ConfigService } from './core/config/config.service'
import {
  UpperCaseFormatProvider,
  JsonFormatProvider,
  BrowserConsoleOutputProvider,
  ILogMessage,
  LogLevel, LoggerService
} from './core/logger/logger.service'

import { LoggingApiService } from './core/logger/logging-api.service'
import { Search } from './core/search/search.interface'
import { Data } from './core/database/data'
import { MemoryDbLocalStorageMode, MemoryDbVariableMode } from './core/database/memorydb'

@Component({
  selector: 'app-root',
  encapsulation: ViewEncapsulation.None,
  styleUrls: ['../assets/uswds/css/uswds.min.css',
    '../assets/css/ngx-datatable.css',
    './app.component.css',
    '../assets/css/calendar.scss'
  ],
  templateUrl: './app.component.html',
  providers: [MenusService,
    ErrorService,
    MainContentService
  ]
})

export class AppComponent implements OnInit {
  searchGroup: FormGroup
  searchVal: FormControl

  search: string
  product = 'home'
  productLink = '?'

  titles = ['TAS Web Application', 'title2']
  menuService: MenusService
  maincontentService: MainContentService
  errorMessage = ''
  appError: ErrorMessage
  menus: Menu[]
  maincontent: MainContent
  _data: Data

  constructor( @Inject(MenusService) Service,
    private errorService: ErrorService,
    private router: Router,
    private loggingApiService: LoggingApiService,
    private loggerService: LoggerService,
    private configService: ConfigService,
    private mcService: MainContentService) {
    this.menuService = Service
    this.maincontentService = mcService
    this._data = new Data(new MemoryDbVariableMode())
    errorService.errorCode$.subscribe(newErr => this.appError = newErr);
    console.log("AppComponent::.ctor")
    this.configService.setDefaults()
      .then(async () => {
        const logLevel = await this.configService.load(Config.LogLevel)
        // console.log(`>>>>>>>>>>>>>>>>>>>>>>>logLevel:${logLevel}`)
        this.loggerService.setlogLevel(LogLevel[<string>logLevel])
        this.router.events.subscribe((val) => {
          this.loggerService.info(val.toString())
        })
        const enableApiLogging = LocalConfig.EnableApiLogging
        if (enableApiLogging) {
          console.log('TRUE === enableApiLogging')
          this.loggerService.setOutputProvider((data: ILogMessage): void => {
            BrowserConsoleOutputProvider(data)
            this.loggingApiService.add(data.level.toString(), data.message)
              .subscribe(id => {
                console.log('loggingApiService::add called|id:' + id)
                let options = { page: 1, pageSize: 4 }
                options['text'] = 'urlAfterRedirects'
                this.loggingApiService.get(options)
                  .subscribe(logData => {
                    console.log(`loggingApiService::getAll called|logData.total:${JSON.stringify(logData.total)}|logData.items.length:${JSON.stringify(logData.items.length)}`)
                  })
              })
          })
        } else {
          this.loggerService.setOutputProvider(BrowserConsoleOutputProvider)
        }
      })
  }

  ngOnInit() {

    this.menuService.getMenus().subscribe(this.menuUpdate.bind(this))

    this.maincontentService.getContent().subscribe(this.contentUpdate.bind(this))

    this.searchGroup = new FormGroup({
      searchVal: new FormControl('', Validators.required)
    })
  }

  isRouteLink(sub) {

    if (typeof sub.uri === 'undefined') {
      return false
    }
    if (sub.uri.startsWith('/') === true) {
      return true
    }
    if (typeof sub.isRouteLink !== 'undefined' && sub.isRouteLink === true) {
      return true
    }
    if (sub.uri.indexOf('http:') === -1 && sub.uri.indexOf('https:') === -1) {
      return true
    }
    return false
  }

  menuUpdate(data: any) {
    this.menus = data;
  }

  contentUpdate(data: any) {
    this.maincontent = data;
    this.setProductLink('home')
  }

  onSearchSubmit() {
    //    console.log("@@@ ="+JSON.stringify(value))
    // TODO get validation working
    if (this.search) {
      this.router.navigate(['/search/' + this.search])
    }
  }

  setProductLink(uri) {
    let prod = uri.split('/')
    if (this.maincontent) {
      for (let i = 0; i < this.maincontent.product.length; i++) {
        if (this.maincontent.product[i].name.toLowerCase() === prod[0].toLowerCase()) {
          this.productLink = this.maincontent.product[i].erevenueUrl
          return
        }
      }
      this.productLink = this.maincontent.product[0].erevenueUrl
    } else {
      this.productLink = ''
    }
  }

  onSaveChange(value) {
    console.log("onSaveValue =" + value)
    this.search = value
    // TODO get validation working
    //    this.router.navigate(['/search/'+l])
  }

}
